IF NOT OBJECT_ID('UFD_EST_PROD_CPL_MEDIAP_SIMULACAO') IS NULL
	BEGIN
		DROP FUNCTION UFD_EST_PROD_CPL_MEDIAP_SIMULACAO;
	END;
GO	

--SELECT * FROM UFD_EST_PROD_CPL_MEDIAP_SIMULACAO(1,1,1,0,15)

CREATE FUNCTION UFD_EST_PROD_CPL_MEDIAP_SIMULACAO(@CD_EMP    INT
													, @CD_FILIAL INT
													, @CD_PROD   INT
													, @MEDIAP    MONEY
													, @QEMAX     MONEY
													)
RETURNS @RS_RETORNO TABLE (CD_SIGLA INT
							, EMAX     MONEY
							, ESEG     MONEY
							, MEDIAP   MONEY
							, QEMAX    MONEY
							, QESEG    MONEY
							)
AS
	 BEGIN
		 
		 DECLARE @CD_LINHA INT
		 SET @CD_LINHA = ISNULL((SELECT TOP 1
									CD_ARV_MERC_LINHA
										FROM EST_PROD_EST_ARV_MERCADOLOGICA
										WHERE	CD_EMP=@CD_EMP AND
											CD_PROD =@CD_PROD),0);
			

		 INSERT INTO @RS_RETORNO
		 SELECT TOP 1
				PARAM_CURVA.CD_SIGLA
			  , PARAM_MEDIA.EMAX
			  , PARAM_MEDIA.ESEG
			  , ROUND((CASE
						   WHEN @MEDIAP = 0 THEN(@QEMAX * 30 / PARAM_MEDIA.EMAX)
						   ELSE @MEDIAP
					   END), 4) AS MEDIAP
			  , ROUND((CASE
						   WHEN @QEMAX = 0 THEN ROUND((@MEDIAP / 30) * PARAM_MEDIA.EMAX, 0)
						   ELSE @QEMAX
					   END), 0) AS QEMAX
			  , ROUND((CASE
						   WHEN @QEMAX = 0 THEN ROUND((@MEDIAP / 30) * PARAM_MEDIA.ESEG, 0)
						   ELSE ROUND(((@QEMAX * 30 / PARAM_MEDIA.EMAX) / 30) * PARAM_MEDIA.ESEG, 0)
					   END), 0) AS QSEG
		 FROM
			 V_EST_ARV_MD_F_GRP_PARAM_CURVA_PRC_FILIAL PARAM_CURVA
			 INNER JOIN V_EST_ARV_MD_F_GRP_PARAM_PRC_FILIAL PARAM_MEDIA ON PARAM_CURVA.CD_EMP = PARAM_MEDIA.CD_EMP
																		   AND PARAM_CURVA.CD_FILIAL = PARAM_MEDIA.CD_FILIAL
																		   AND PARAM_CURVA.CD_SIGLA = PARAM_MEDIA.CD_SIGLA

			
			 
		 WHERE  PARAM_CURVA.CD_EMP = @CD_EMP
				AND PARAM_CURVA.CD_FILIAL	= @CD_FILIAL
				AND PARAM_CURVA.CD_PROD		= @CD_PROD
				AND PARAM_MEDIA.CD_ARV_MERC_LINHA = @CD_LINHA
				AND PARAM_MEDIA.EMAX > 0
				AND ROUND((CASE
							   WHEN @MEDIAP = 0 THEN(@QEMAX * 30 / PARAM_MEDIA.EMAX)
							   ELSE @MEDIAP
						   END), 4) >= PARAM_CURVA.VLR_PARAMETRO
		 ORDER BY
				  PARAM_CURVA.VLR_PARAMETRO DESC;
		 RETURN;
	 END;